;==============================================================================
; BitCount2
;------------------------------------------------------------------------------

; Bit counting using a 128 byte pre-calculated table.
;
;==============================================================================
; Revision History
;
; 13-08-2007 AJ First Release
;------------------------------------------------------------------------------
; $Id$
;------------------------------------------------------------------------------

                .6502

                .GLOBAL BitCount2

                .CODE

; If we shift the top bit into the carry before the lookup we can halve the
; size of the lookup table at the cost of a few more instructions.

BitCount2:      CLC                     ; Put the high bit of the value into C
                ADC #$80
                AND #$7F                ; Form an index from the low 7 bits
                TAX
                LDA Bits,X              ; Lookup the main part of the result
                ADC #0                  ; And add in the 8th bit.
                RTS

; Bit counts for values $00 to $7F

Bits            .BYTE 0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4
                .BYTE 1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
                .BYTE 1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7

                .END